<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( 'You are not allowed to call this page directly.' );
}

class FrmTransLiteListsController {

	/**
	 * @return void
	 */
	public static function add_list_hooks() {
		$unread_count = FrmEntriesHelper::get_visible_unread_inbox_count();
		$hook_name    = 'manage_' . sanitize_title( FrmAppHelper::get_menu_name() ) . ( $unread_count ? '-' . $unread_count : '' ) . '_page_formidable-payments_columns';

		add_filter( $hook_name, self::class . '::payment_columns' );
		add_filter( 'screen_options_show_screen', self::class . '::remove_screen_options', 10, 2 );
	}

	/**
	 * @param array $columns
	 *
	 * @return array
	 */
	public static function payment_columns( $columns = array() ) {
		add_screen_option(
			'per_page',
			array(
				'label'   => esc_html__( 'Payments', 'formidable' ),
				'default' => 20,
				'option'  => 'formidable_page_formidable_payments_per_page',
			)
		);

		$type = FrmAppHelper::get_simple_request(
			array(
				'param'   => 'trans_type',
				'type'    => 'request',
				'default' => 'payments',
			)
		);

		$columns['cb']      = '<input type="checkbox" />';
		$columns['user_id'] = esc_html__( 'Customer', 'formidable' );

		if ( 'subscriptions' === $type ) {
			$add_columns = array(
				'sub_id'         => esc_html__( 'Profile ID', 'formidable' ),
				'item_id'        => esc_html__( 'Entry', 'formidable' ),
				'form_id'        => esc_html__( 'Form', 'formidable' ),
				'amount'         => esc_html__( 'Billing Cycle', 'formidable' ),
				'end_count'      => esc_html__( 'Payments Made', 'formidable' ),
				'next_bill_date' => esc_html__( 'Next Bill Date', 'formidable' ),
			);
		} else {
			$add_columns = array(
				'receipt_id'  => esc_html__( 'Receipt ID', 'formidable' ),
				'item_id'     => esc_html__( 'Entry', 'formidable' ),
				'form_id'     => esc_html__( 'Form', 'formidable' ),
				'amount'      => esc_html__( 'Amount', 'formidable' ),
				'sub_id'      => esc_html__( 'Subscription', 'formidable' ),
				'begin_date'  => esc_html__( 'Begin Date', 'formidable' ),
				'expire_date' => esc_html__( 'Expire Date', 'formidable' ),
			);
		}

		$columns = $columns + $add_columns;

		$columns['status']     = esc_html__( 'Status', 'formidable' );
		$columns['created_at'] = esc_html__( 'Date', 'formidable' );
		$columns['paysys']     = esc_html__( 'Processor', 'formidable' );

		if ( 'bulk_delete' !== FrmAppHelper::simple_get( 'action' ) && ! class_exists( 'FrmTransListHelper' ) && class_exists( 'FrmPaymentsListHelper' ) ) {
			$columns['mode'] = esc_html__( 'Mode', 'formidable' );
		}

		return $columns;
	}

	/**
	 * Prevent the "screen options" tab from showing when
	 * viewing a payment or subscription
	 *
	 * @since 6.5
	 *
	 * @param bool   $show_screen Whether to show the screen options tab.
	 * @param object $screen      The current screen.
	 *
	 * @return bool
	 */
	public static function remove_screen_options( $show_screen, $screen ) {
		if ( ! in_array( FrmAppHelper::simple_get( 'action', 'sanitize_title' ), array( 'edit', 'show', 'new', 'duplicate' ), true ) ) {
			return $show_screen;
		}

		$menu_name    = sanitize_title( FrmAppHelper::get_menu_name() );
		$unread_count = FrmEntriesHelper::get_visible_unread_inbox_count();

		if ( $unread_count ) {
			$menu_name .= '-' . $unread_count;
		}

		if ( $screen->id === $menu_name . '_page_formidable-payments' ) {
			$show_screen = false;
		}

		return $show_screen;
	}

	/**
	 * Handle payment/subscription list routing.
	 *
	 * @param string $action
	 *
	 * @return void
	 */
	public static function route( $action ) {
		if ( 'coupons' === $action ) {
			FrmAppHelper::permission_check( 'frm_change_settings' );

			include FrmTransLiteAppHelper::plugin_path() . '/views/lists/coupons.php';
			return;
		}

		/**
		 * @since 6.27
		 *
		 * @param bool   $route_handled
		 * @param string $action
		 */
		$route_handled = apply_filters( 'frm_trans_lite_route', false, $action );

		if ( $route_handled ) {
			return;
		}

		self::display_list();
	}

	/**
	 * @return array
	 */
	public static function list_page_params() {
		$values = array();

		foreach ( array(
			'id'     => '',
			'paged'  => 1,
			'form'   => '',
			'search' => '',
			'sort'   => '',
			'sdir'   => '',
		) as $var => $default ) {
			$values[ $var ] = FrmAppHelper::get_param( $var, $default );
		}

		return $values;
	}

	/**
	 * Display a list.
	 *
	 * @param array $response
	 *
	 * @return void
	 */
	public static function display_list( $response = array() ) {
		FrmAppHelper::include_svg();

		$defaults      = array(
			'errors'  => array(),
			'message' => '',
		);
		$response      = array_merge( $defaults, $response );
		$errors        = $response['errors'];
		$message       = $response['message'];
		$wp_list_table = new FrmTransLiteListHelper( self::list_page_params() );
		$pagenum       = $wp_list_table->get_pagenum();

		$wp_list_table->prepare_items();

		$total_pages = $wp_list_table->get_pagination_arg( 'total_pages' );

		if ( $pagenum > $total_pages && $total_pages > 0 ) {
			// if the current page is higher than the total pages,
			// reset it and prepare again to get the right entries.
			$_GET['paged']     = $total_pages;
			$_REQUEST['paged'] = $total_pages;
			$pagenum           = $wp_list_table->get_pagenum();
			$wp_list_table->prepare_items();
		}

		include FrmTransLiteAppHelper::plugin_path() . '/views/lists/list.php';
	}

	/**
	 * @param mixed  $save
	 * @param string $option
	 * @param int    $value
	 *
	 * @return mixed
	 */
	public static function save_per_page( $save, $option, $value ) {
		if ( $option === 'formidable_page_formidable_payments_per_page' ) {
			$save = absint( $value );
		}
		return $save;
	}
}
